##
### Seção 8 - PHP 8 Básico e Intermédio
##



<p align="center">
  <img alt="...." src="../Seção 8 - PHP 8 Básico e Intermédio/aassets/PHP-logo.svg.png" width="70%">
</p>


### 269 - O que é o PHP, Ainda Vale a Pena Aprender


**O que é o PHP?**

PHP: **Hypertext Preprocessure** (Originalmente designado por Personal Home Page)


Linguagem de programação script, interpretada, que funciona do laado do servidor web, para a criação de conteúdo dinâmico nas páginas e aplicações web.


Linguagem **interpretada** vs Linguagem **compilada**



**O que é o PHP?**

- Linguagem script *Server-Side*
- É interpretada do lado do servidor
- Permite comunicar com vários tipos de bases de dados
- É uma tecnologia *Open Source*
- É gratuita para uso particular ou comercial
- Baseada na sintaxe da **Linguagem C**
- Simples de aprender, mas bastante extensa


**O que Podemos fazer com o PHP?**

- Criar *soluções completas* para a web
- Criar APIs para alimentação de dados do *front end*
- Tratar a submissão de formulários, cookies, sessões, ect...
- Manipulação direta de dados
- Manipulação de ficheiros e pastas do servidor
- Criar sistemas completos (websites, web apps, webservices)


**Como estudar o PHP (Versão 8.x)?**

- Vamos começãr pelo básico e intermédio  (**PHP Procedural**)
- Depois vamos aprender **Orientação a Objetos** em PHP
- Como comunicar com a **bases de dados**
- Conceitos mais avançados de PHP
- Como criar do zero até a solução online
- Boas práticas de programação com a linguagem


**O PHP ainda está "vivo"?**

- Já foi decretado seu desparecimento *centenas de vezes*
- Continua a ser utilizado com muita frenquência
- Alimenta milhões de sistemas web
- Permite desenvolver soluções milionárias
- É de fácil implementação do lado do servidor
- Tem uma comunidade gigantesca de programadores


**Vamos começar por perceber como funciona o PHP**


- Sem projeto

- Exemplo 
    - php-web_01

### 270 - Como Funciona o PHP?


**Como funciona**


<p align="center">
  <img alt="...." src="../Seção 8 - PHP 8 Básico e Intermédio/aassets/php-1.jpg" width="80%">
</p>


- Sem projeto

- Exemplo 
    - php-web_02




### 271 - Requisitos Básicos Para Aprender PHP


**Requisitos para aprender PHP**

- Conhecimento sólido de **HTML**
- Conhecer outras linguagem pode facilitar o estudo (baseado na sintaxe da linguagem c)
- Um **ambiente de desenvolvimento local**
- Um editor de código prepardo pra **PHP** (Visual Studio Code)
- Perceber os conceitos fundamentais da linguagem e...

**Escrever muito código**


- Sem projeto

- Exemplo 
    - php-web_03









### 272 - Como Instalar o Xampp


**Xampp**

- Xampp (Downloads)
  - Site: https://www.apachefriends.org/pt_br/index.html

- Sem projeto

- Exemplo 
    - php-web_04




### 273 - Como Instalar o WampServer


**WampServer**

- WampServer (Downloads)
  - Site: https://www.wampserver.com/en/

- Sem projeto

- Exemplo 
    - php-web_05





### 274 - Como Instalar o Mamp


**Mamp**

- Mamp (Downloads)
  - Site: https://www.mamp.info/en/downloads/

- Sem projeto

- Exemplo 
    - php-web_06





### 275 - Como Instalar o Laragon


**Laragon**

- Laragon (Downloads)
  - Site: https://laragon.org/download/index.html

- Sem projeto

- Exemplo 
    - php-web_07




### 276 - Como Usar o Laragon


**Laragon**

- Sem projeto

- Exemplo 
    - php-web_08


### 277 - Como Adicionar o PHP8 ao Laragon

**Laragon**

- Sem projeto

- Exemplo 
    - php-web_09




### 278 - Escrever Código de PHP

**PHP**

**Visual Studio Code**

- Extensão
  - `PHP Intelephense`

- Exemplo 
    - php-web_10


### 279 - Como Executar o PHP no Terminal

**Terminal**

- Configurar Variaveis do Ambiente

- Listar pastas
```
ls
```

- Acessar pasta
```
cd php-web_11
```

- Verifica a versão do PHP instalado
```
php -v
```

- Executar o projeto no terminal
```
php index.php
```


- Exemplo 
    - php-web_11




### 280 - Comentários em PHP


- Exemplos de Comentários em PHP
```php
// single-line comment

# single-line comment

/* multi-line
comment */

// ---------------------------------------------------
// Comentários podem entrar aqui
// ---------------------------------------------------

# ----------------------------------------------------
# Comentários podem entrar aqui
# ----------------------------------------------------

/* ---------------------------------------------------
Comentários podem entrar aqui
E nesta segunda linha também 
--------------------------------------------------- */
```

- Exemplo 
    - php-web_12


### 281 - Definição de Variáveis em PHP


- Exemplo 
    - php-web_13



### 282 - Atribuir Valores a Variáveis

- Exemplo 
    - php-web_14



### 283 - Constantes

- Exemplo 
    - php-web_15


### 284 - Data Types

- Exemplo 
    - php-web_16




### 285 - Booleanos

- Exemplo 
    - php-web_17



### 286 - Integers

- Exemplo 
    - php-web_18





### 287 - Floats

- Exemplo 
    - php-web_19




### 288 - Null

- Exemplo 
    - php-web_20




### 289 - Strings

- Exemplo 
    - php-web_21




### 290 - Arrays

- Exemplo 
    - php-web_22



### 291 - Arrays Multidimensionais

- Exemplo 
    - php-web_23




### 292 - Funções Associadas a Arrays


**Array Functions**

- Array Functions
    - Site: https://www.php.net/manual/en/ref.array.php


- Exemplo 
    - php-web_24





### 293 - Operadores Matemáticos


- Exemplo 
    - php-web_25




### 294 - Exercícios Práticos Com Operadores Matemáticos


- Exemplo 
    - php-web_26


### 295 - Operadores de Atribuição


- Exemplo 
    - php-web_27



### 296 - Operadores de Strings


- Exemplo 
    - php-web_28



### 297 - Operadores de Comparação


- Exemplo 
    - php-web_29



### 298 - Operadores de Controle de Erro


- Exemplo 
    - php-web_30



### 299 - Operadores de Incremento & Decremento


- Exemplo 
    - php-web_31



### 300 - Operadores Lógicos


- Exemplo 
    - php-web_32



### 301 - Precedência de Operadores


- Exemplo 
    - php-web_33



### 302 - Instrução Condicional If ElseIf Else


- Exemplo 
    - php-web_34




### 303 - Exercícios Práticos com Arrays & Instruções Condicionais


- Exemplo 
    - php-web_35





### 304 - Instrução Condicional Switch


- Exemplo 
    - php-web_36




### 305 - Instrução Condicional Match


- Exemplo 
    - php-web_37




### 306 - Operador Ternário


- Exemplo 
    - php-web_38




### 307 - Ciclos While & Do While


- Exemplo 
    - php-web_39




### 308 - Ciclo For


- Exemplo 
    - php-web_40




### 309 - Ciclo Foreach


- Exemplo 
    - php-web_41




### 310 - Break & Continue


- Exemplo 
    - php-web_42




### 311 - Exercício Práticos

- ...
```php
<?php ?>
```

- ...
```php
<?= ?>
```

- Exemplo 
    - php-web_43






### 312 - Introdução a Criação de Funções


- Exemplo 
    - php-web_44




### 313 - Parâmetros de Uma Função


- Exemplo 
    - php-web_45


### 314 - Escopo de Variáveis


- Exemplo 
    - php-web_46



### 315 - Inclusão de Ficheiros com Require & Include


- Exemplo 
    - php-web_47




### 316 - Exemplo Prático do Uso de Inclusão de Scripts


- Exemplo 
    - php-web_48




### 317 - Cuidado com os Caminhos na Inclusão de Scripts


- Exemplo 
    - php-web_49



### 318 - Introdução as Sessões


- Exemplo 
    - php-web_50




### 319 - Detalhando Exercício com Sessões

- C:\laragon\tmp
```
inspecionar/aplication/cookies/localhost/PHPSESSID
```

- sess_4h56r41jn53g0bfhfi6ggqh730
```
nome|s:6:"Daniel";apelido|s:8:"Oliveira";
```

- Exemplo 
    - php-web_51




### 320 - Configuração do Cookie da Sessão


- Exemplo 
    - php-web_52





### 321 - O Que São e Como Usar Cookies No PHP


- Exemplo 
    - php-web_53


### 322 - Introdução a Manipulação do FileSystem com PHP


- Exemplo 
    - php-web_54



### 323 - Informações Sobre Ficheiros & Guardar Dados com file_put_contents


- Exemplo 
    - php-web_55



### 324 - Ler Dados a Partir de um Ficheiro de Texto


- Exemplo 
    - php-web_56



### 325 - Ler & Escrever Ficheiros CSV


- Exemplo 
    - php-web_57



### 326 - Copiar, Mover, Renomear & Eliminar Ficheiros


- Exemplo 
    - php-web_58


### 327 - Constantes Mágicas


- Exemplo 
    - php-web_59



### 328 - Super Globais

- Exemplo 
    - php-web_60


### 329 - Capturando Variáveis da URI com $_GET


- Exemplo 
    - php-web_61




### 330 - Tratamento de Formulários - Introdução

- Exemplo 
    - php-web_62



### 331 - $_GET Versus $_POST

- Exemplo 
    - php-web_63



### 332 - Tratamento de Diferentes Tipos de Inputs

- Exemplo 
    - php-web_64



### 333 - Validação de Formulários - Parte 1

- Exemplo 
    - php-web_65


### 334 - Validação de Formulários - Parte 2

- Exemplo 
    - php-web_66



### 335 - A Simples & Complexa Validação de Dados

- Exemplo 
    - php-web_67


### 336 - Funções Relacionadas com Erros


- Exemplo 
    - php-web_68



### 337 - Tratamento de Erros


- Exemplo 
    - php-web_69



### 338 - Exercício 1


- Exemplo 
    - php-web_70



### 339 - Exercício 2


- Exemplo 
    - php-web_71


### 340 - Exercício 3


- Exemplo 
    - php-web_72



### 341 - Exercício 4


- Exemplo 
    - php-web_73









